#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Rumah Belajar Sudimoro & Ngargosoko', '6285641568590', 'noviandri356@gmail.com', 'Jombong RT. 02 RW. 01 Sudimoro Srumbung Magelang', 'Logo-1766065603.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (35, 'Membaca (AHE)', '2025-12-20 11:07:23');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (36, 'Berhitung (ASE)', '2025-12-20 11:07:31');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (37, 'Mengaji (AGA)', '2025-12-20 11:07:41');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (38, 'Bahasa Inggris ', '2025-12-20 11:10:16');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (39, 'Mapel SD', '2025-12-20 11:10:57');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (40, 'Tahfidz Qur\'an', '2025-12-20 12:19:29');


#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=681 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (636, 1, 466, 36, '100000', 27, 'Aktif', '0000-00-00', '2025-12-20 11:23:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (637, 1, 467, 36, '120000', 7, 'Aktif', '0000-00-00', '2025-12-20 11:24:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (638, 1, 469, 36, '100000', 16, 'Aktif', '0000-00-00', '2025-12-20 12:01:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (639, 1, 470, 37, '120000', 4, 'Aktif', '0000-00-00', '2025-12-20 12:08:41');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (640, 1, 471, 37, '120000', 16, 'Aktif', '0000-00-00', '2025-12-20 12:11:12');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (641, 1, 472, 35, '120000', 23, 'Aktif', '0000-00-00', '2025-12-20 12:13:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (642, 1, 473, 38, '150000', 3, 'Aktif', '0000-00-00', '2025-12-20 12:16:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (643, 1, 475, 37, '120000', 6, 'Aktif', '0000-00-00', '2025-12-20 12:21:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (644, 1, 475, 36, '120000', 6, 'Aktif', '0000-00-00', '2025-12-20 12:21:56');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (645, 1, 476, 36, '120000', 10, 'Aktif', '0000-00-00', '2025-12-20 12:25:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (646, 1, 479, 35, '120000', 2, 'Aktif', '0000-00-00', '2025-12-20 12:30:43');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (647, 1, 480, 35, '120000', 9, 'Aktif', '0000-00-00', '2025-12-20 12:32:21');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (648, 1, 481, 35, '120000', 9, 'Aktif', '0000-00-00', '2025-12-20 12:34:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (649, 1, 482, 35, '120000', 27, 'Aktif', '0000-00-00', '2025-12-20 12:37:36');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (650, 1, 485, 35, '120000', 25, 'Aktif', '0000-00-00', '2025-12-20 12:43:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (651, 1, 487, 35, '120000', 3, 'Aktif', '0000-00-00', '2025-12-20 12:48:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (652, 1, 488, 36, '120000', 24, 'Aktif', '0000-00-00', '2025-12-20 12:50:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (653, 1, 489, 35, '120000', 3, 'Aktif', '0000-00-00', '2025-12-20 12:51:52');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (654, 1, 490, 35, '120000', 29, 'Aktif', '0000-00-00', '2025-12-20 13:03:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (655, 1, 491, 35, '120000', 2, 'Aktif', '0000-00-00', '2025-12-20 13:18:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (656, 1, 492, 35, '120000', 29, 'Aktif', '0000-00-00', '2025-12-20 13:21:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (657, 1, 493, 35, '120000', 5, 'Aktif', '0000-00-00', '2025-12-20 13:22:54');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (658, 1, 494, 35, '120000', 2, 'Aktif', '0000-00-00', '2025-12-20 13:24:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (659, 1, 496, 35, '120000', 4, 'Aktif', '0000-00-00', '2025-12-20 13:27:45');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (660, 1, 497, 35, '120000', 6, 'Aktif', '0000-00-00', '2025-12-20 13:31:12');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (661, 1, 498, 35, '120000', 6, 'Aktif', '0000-00-00', '2025-12-20 13:32:50');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (662, 1, 499, 35, '120000', 9, 'Aktif', '0000-00-00', '2025-12-20 13:38:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (663, 1, 500, 35, '120000', 26, 'Aktif', '0000-00-00', '2025-12-20 13:40:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (664, 1, 501, 35, '120000', 23, 'Aktif', '0000-00-00', '2025-12-20 13:42:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (665, 1, 502, 36, '100000', 25, 'Aktif', '0000-00-00', '2025-12-20 13:45:41');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (666, 1, 503, 36, '120000', 2, 'Aktif', '0000-00-00', '2025-12-20 13:46:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (667, 1, 504, 36, '120000', 6, 'Aktif', '0000-00-00', '2025-12-20 13:48:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (668, 1, 505, 37, '120000', 16, 'Aktif', '0000-00-00', '2025-12-20 13:50:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (669, 1, 505, 40, '120000', 16, 'Aktif', '0000-00-00', '2025-12-20 13:52:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (670, 1, 506, 35, '120000', 20, 'Aktif', '0000-00-00', '2025-12-20 13:53:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (671, 1, 508, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:30:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (672, 1, 509, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:33:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (673, 1, 510, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:37:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (674, 1, 511, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:40:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (675, 1, 512, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:42:29');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (676, 1, 513, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:45:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (677, 1, 514, 38, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 14:48:13');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (678, 1, 484, 35, '120000', 27, 'Aktif', '0000-00-00', '2025-12-20 15:29:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (679, 1, 515, 37, '120000', 5, 'Aktif', '0000-00-00', '2025-12-20 15:51:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (680, 1, 478, 40, '120000', 2, 'Aktif', '0000-00-00', '2026-01-13 09:24:14');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4006 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4000, 1, '2404:c0:b602:ff62:ae66:8eb:8ad:e', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Login', '2025-12-18 20:46:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4001, 1, '2404:c0:b602:ff62:ae66:8eb:8ad:e', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Logout', '2025-12-18 20:46:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4002, 1, '110.76.147.37', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:146.0) Gecko/20100101 Firefox/146.0', 'Login', '2025-12-20 11:01:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4003, 1, '110.76.147.37', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:146.0) Gecko/20100101 Firefox/146.0', 'Login', '2026-01-07 19:45:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4004, 1, '182.8.225.13', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:146.0) Gecko/20100101 Firefox/146.0', 'Login', '2026-01-12 12:55:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4005, 1, '110.76.147.37', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:146.0) Gecko/20100101 Firefox/146.0', 'Login', '2026-01-13 09:08:33');


#
# TABLE STRUCTURE FOR: tb_qris
#

DROP TABLE IF EXISTS `tb_qris`;

CREATE TABLE `tb_qris` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gambar` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_qris` (`id`, `gambar`) VALUES (1, 'b01271c874ebc6e5dce6e580ec5bbb0b.jpeg');


#
# TABLE STRUCTURE FOR: tb_rekening
#

DROP TABLE IF EXISTS `tb_rekening`;

CREATE TABLE `tb_rekening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namaBank` varchar(10) NOT NULL,
  `noRekening` varchar(20) NOT NULL,
  `pemilik` varchar(50) NOT NULL,
  `terdaftar` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_rekening` (`id`, `namaBank`, `noRekening`, `pemilik`, `terdaftar`) VALUES (1, 'BRI', '679601021845535', 'Novi Andriyani Putri', '2025-12-20 15:00:47');
INSERT INTO `tb_rekening` (`id`, `namaBank`, `noRekening`, `pemilik`, `terdaftar`) VALUES (2, 'BSI', '7182751442', 'Novi Andriyani Putri', '2025-12-20 15:01:37');


#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'ahesudimoromagelang', '2026-12-19');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=516 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (466, '076', 'Kinan Aqilla Raisa Putri', 'Perempuan', '082325977737', '2018-10-14', '2023-06-27', '2025-12-20 11:16:41');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (467, '107', 'Delisa Adzra Azkadina', 'Perempuan', '6283152007161', '2018-05-16', '2024-03-07', '2025-12-20 11:18:56');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (468, '112', 'Muhammad Vino S', 'Perempuan', '6281226010502', '2017-07-08', '2024-06-06', '2025-12-20 11:20:25');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (469, '057', 'Erzan Evino Pradana', 'Laki-Laki', '6287834302799', '2017-03-14', '2022-09-16', '2025-12-20 12:01:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (470, '113', 'Muhammad Andana Rafadhan ', 'Laki-Laki', '628197155003', '2017-07-06', '2024-06-04', '2025-12-20 12:08:09');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (471, '121', 'Adilla Nisa Rahmawati', 'Perempuan', '6287739339377', '2018-11-27', '2024-07-16', '2025-12-20 12:10:44');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (472, '122', 'Ilyas Azfer Rafif', 'Laki-Laki', '6281225696412', '2019-03-21', '2024-07-23', '2025-12-20 12:12:50');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (473, '039', 'Aysya Azzahra Mecca', 'Perempuan', '6285725772466', '2018-09-22', '2024-08-03', '2025-12-20 12:15:28');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (474, '123', 'Desiana Indah Sari', 'Perempuan', '6283891219660', '2018-04-24', '2024-08-03', '2025-12-20 12:17:47');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (475, '126', 'Delisha Nur Maulida', 'Perempuan', '6287829481622', '2018-11-13', '2024-08-06', '2025-12-20 12:19:11');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (476, '129', 'Maulidha Hasna Nadhifa', 'Perempuan', '6285141365090', '0007-11-29', '2024-09-10', '2025-12-20 12:23:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (477, '132', 'Sheza Aurelia Zafarani', 'Perempuan', '6281252365550', '2018-10-16', '2024-03-01', '2025-12-20 12:26:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (478, '134', 'Rayna Salsabila Pratista', 'Perempuan', '628305233725', '2018-09-15', '2024-11-02', '2025-12-20 12:27:47');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (479, '133', 'Asfan Alesha Fauzia', 'Perempuan', '6285228910404', '2018-07-29', '2024-11-02', '2025-12-20 12:30:16');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (480, '137', 'Arzan Wildan', 'Laki-Laki', '6281325089466', '2019-09-24', '2025-01-09', '2025-12-20 12:31:57');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (481, '138', 'Rachel Naufalyn Inara', 'Perempuan', '628232830108', '2019-11-30', '2025-01-09', '2025-12-20 12:33:57');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (482, '141', 'Yasmin Faiqa Pahleri', 'Perempuan', '6283869694487', '2019-07-17', '2025-09-27', '2025-12-20 12:37:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (483, '137', 'Hafizan Athar Alfarizqi', 'Laki-Laki', '6288806606068', '2018-06-22', '2025-01-01', '2025-12-20 12:39:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (484, '140', 'Muhammad Kaysan Atharis', 'Laki-Laki', '6283145822832', '2020-01-15', '2025-01-27', '2025-12-20 12:41:35');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (485, '142', 'Prabu Maulana Bumi', 'Laki-Laki', '6285743250750', '2018-11-11', '2024-04-25', '2025-12-20 12:43:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (486, '143', 'Andara Odelia Maheswari', 'Perempuan', '6285800152533', '2018-08-18', '2025-05-15', '2025-12-20 12:45:53');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (487, '144', 'Qiandra Nathania Shanum', 'Perempuan', '6281232745612', '2019-03-10', '2025-06-03', '2025-12-20 12:47:39');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (488, '146', 'Icha Putri Aprilia', 'Perempuan', '6283154576160', '2019-04-10', '2025-07-24', '2025-12-20 12:49:19');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (489, '145', 'Azizah Noureen Falisha', 'Perempuan', '6285602333628', '2018-04-20', '2025-07-03', '2025-12-20 12:51:26');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (490, '148', 'Evano Alfarizky Mustofa', 'Laki-Laki', '6289699776499', '2021-03-25', '2025-07-29', '2025-12-20 12:59:14');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (491, '149', 'Milkhayla Syifania Zea Elshanum', 'Perempuan', '6281326472594', '2019-06-07', '2025-08-02', '2025-12-20 13:18:26');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (492, '147', 'Rasyid Zyan Ramadhan', 'Laki-Laki', '6281389400946', '2018-05-07', '2025-07-29', '2025-12-20 13:21:07');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (493, '150', 'Noiana Arifah', 'Perempuan', '6282137117993', '2018-11-18', '2025-08-05', '2025-12-20 13:22:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (494, '153', 'Choiril Rafqi Alfarezel', 'Laki-Laki', '6283152700978', '2019-07-18', '2025-09-02', '2025-12-20 13:24:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (495, '160', 'Cici Rauma Anandari Octaviana', 'Perempuan', '6288980906227', '2020-10-10', '2025-09-02', '2025-12-20 13:26:12');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (496, '154', 'Kirana Putri Az-Zahra', 'Perempuan', '6283128815696', '2019-12-16', '2025-09-04', '2025-12-20 13:27:27');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (497, '155', 'Saffana Intan Fauwzia', 'Perempuan', '6283144947919', '2018-12-12', '2025-09-06', '2025-12-20 13:30:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (498, '156', 'Rasyiqul Abid Habibi', 'Laki-Laki', '6283152007161', '2020-03-10', '2025-09-06', '2025-12-20 13:32:34');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (499, '158', 'Ghani Shafwan Putra', 'Perempuan', '6282247278392', '2018-06-17', '2025-09-09', '2025-12-20 13:38:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (500, '152', 'Faqih Fairuza Putra Endita', 'Laki-Laki', '6282236523512', '2020-11-02', '2025-08-26', '2025-12-20 13:40:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (501, '157', 'Ahmad Kafa Billah', 'Laki-Laki', '6285869848129', '2017-08-18', '2025-08-23', '2025-12-20 13:42:12');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (502, '071', 'Nando Bagus Pratama', 'Laki-Laki', '6282138048865', '2018-09-28', '2023-05-25', '2025-12-20 13:43:52');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (503, '159', 'Gany Keyno Wicaksono', 'Laki-Laki', '6285743782333', '2017-06-08', '2025-10-02', '2025-12-20 13:45:16');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (504, '161', 'Hasna Kayla Putri', 'Perempuan', '6281227100624', '2018-08-08', '2025-12-06', '2025-12-20 13:47:19');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (505, '162', 'Aisyah Ayudia Inara', 'Perempuan', '6281299537994', '0017-09-06', '2025-12-16', '2025-12-20 13:48:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (506, '163', 'Verrel Verdian Saputra', 'Laki-Laki', '6281325498085', '2018-05-09', '2025-12-20', '2025-12-20 13:50:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (507, '151', 'Naura Yasmin Khairunissa', 'Perempuan', '6285876076624', '2018-09-22', '2025-08-26', '2025-12-20 14:25:18');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (508, '034', 'Andyra Naifa F ', 'Perempuan', '6285796111946', '2018-01-10', '2025-06-01', '2025-12-20 14:29:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (509, '034', 'Rania Aisy Hanna', 'Perempuan', '6282225837104', '2018-07-01', '2025-06-01', '2025-12-20 14:33:11');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (510, '036', 'Citra Aprilia Ardani', 'Perempuan', '6285293321022', '2017-04-30', '2025-06-01', '2025-12-20 14:37:08');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (511, '037', 'Adskhan Fahmi Fahwaz', 'Laki-Laki', '6283811963183', '2018-03-15', '2025-06-01', '2025-12-20 14:39:37');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (512, '038', 'Nada Fajria Yumna', 'Perempuan', '6283145131637', '2018-08-28', '2025-06-01', '2025-12-20 14:42:10');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (513, '040', 'Annasya Adreena Sailla', 'Perempuan', '6281217326192', '2018-12-24', '2025-06-01', '2025-12-20 14:44:46');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (514, '041', 'Alexa Chika Hastari', 'Perempuan', '6282221352957', '2018-05-03', '2025-06-01', '2025-12-20 14:47:44');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (515, '100', 'finaya', 'Perempuan', '6283187048702', '2018-06-02', '2024-12-01', '2025-12-20 15:50:32');


#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (59, 1, 12, 2025, '2025-12-20 15:18:11');


#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4630 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4588, 59, 1, 466, 36, '100000', 27, 'Sudah Bayar', '09:17:00', '2025-12-27', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4589, 59, 1, 467, 36, '120000', 7, 'Sudah Bayar', '15:27:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4590, 59, 1, 469, 36, '100000', 16, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4591, 59, 1, 470, 37, '120000', 4, 'Sudah Bayar', '15:21:00', '2025-12-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4592, 59, 1, 471, 37, '120000', 16, 'Sudah Bayar', '13:00:00', '2025-12-30', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4593, 59, 1, 472, 35, '120000', 23, 'Sudah Bayar', '13:12:00', '2025-12-23', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4594, 59, 1, 473, 38, '150000', 3, 'Sudah Bayar', '19:49:00', '2026-01-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4595, 59, 1, 475, 37, '120000', 6, 'Sudah Bayar', '15:32:00', '2025-12-16', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4596, 59, 1, 475, 36, '120000', 6, 'Sudah Bayar', '15:31:00', '2025-12-16', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4597, 59, 1, 476, 36, '120000', 10, 'Sudah Bayar', '15:30:00', '2025-12-16', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4598, 59, 1, 479, 35, '120000', 2, 'Sudah Bayar', '19:55:00', '2025-03-12', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4599, 59, 1, 480, 35, '120000', 9, 'Sudah Bayar', '15:24:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4600, 59, 1, 481, 35, '120000', 9, 'Sudah Bayar', '15:31:00', '2025-12-16', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4601, 59, 1, 482, 35, '120000', 27, 'Sudah Bayar', '15:26:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4602, 59, 1, 485, 35, '120000', 25, 'Sudah Bayar', '09:15:00', '2025-12-27', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4603, 59, 1, 487, 35, '120000', 3, 'Sudah Bayar', '15:25:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4604, 59, 1, 488, 36, '120000', 24, 'Sudah Bayar', '09:10:00', '2026-01-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4605, 59, 1, 489, 35, '120000', 3, 'Sudah Bayar', '15:25:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4606, 59, 1, 490, 35, '120000', 29, 'Sudah Bayar', '09:17:00', '2026-01-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4607, 59, 1, 491, 35, '120000', 2, 'Sudah Bayar', '15:20:00', '2025-12-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4608, 59, 1, 492, 35, '120000', 29, 'Sudah Bayar', '15:19:00', '2025-12-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4609, 59, 1, 493, 35, '120000', 5, 'Sudah Bayar', '09:18:00', '2025-12-30', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4610, 59, 1, 494, 35, '120000', 2, 'Sudah Bayar', '15:22:00', '2025-12-04', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4611, 59, 1, 496, 35, '120000', 4, 'Sudah Bayar', '19:56:00', '2025-12-12', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4612, 59, 1, 497, 35, '120000', 6, 'Sudah Bayar', '15:26:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4613, 59, 1, 498, 35, '120000', 6, 'Sudah Bayar', '15:27:00', '2025-12-09', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4614, 59, 1, 499, 35, '120000', 9, 'Sudah Bayar', '15:24:00', '2025-12-06', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4615, 59, 1, 500, 35, '120000', 26, 'Sudah Bayar', '09:16:00', '2025-12-30', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4616, 59, 1, 501, 35, '120000', 23, 'Sudah Bayar', '09:08:00', '2025-12-30', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4617, 59, 1, 502, 36, '120000', 25, 'Sudah Bayar', '15:34:00', '2025-12-18', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4618, 59, 1, 503, 36, '120000', 2, 'Sudah Bayar', '15:22:00', '2025-12-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4619, 59, 1, 504, 36, '120000', 6, 'Sudah Bayar', '15:23:00', '2025-12-06', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4620, 59, 1, 505, 37, '120000', 16, 'Sudah Bayar', '15:32:00', '2025-12-16', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4621, 59, 1, 505, 40, '120000', 16, 'Sudah Bayar', '15:32:00', '2025-12-16', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4622, 59, 1, 506, 35, '120000', 20, 'Sudah Bayar', '13:01:00', '2025-12-20', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4623, 59, 1, 508, 38, '150000', 1, 'Sudah Bayar', '19:54:00', '2025-12-26', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4624, 59, 1, 509, 38, '150000', 1, 'Sudah Bayar', '19:53:00', '2025-12-07', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4625, 59, 1, 510, 38, '150000', 1, 'Sudah Bayar', '19:51:00', '2026-12-29', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4626, 59, 1, 511, 38, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4627, 59, 1, 512, 38, '150000', 1, 'Sudah Bayar', '19:51:00', '2026-12-26', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4628, 59, 1, 513, 38, '150000', 1, 'Sudah Bayar', '19:47:00', '2026-01-02', 'Approve', '2025-12-20 15:18:11');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4629, 59, 1, 514, 38, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-20 15:18:11');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Noviandriani Putri', 'Perempuan', '6285641568590', 'noviandri356@gmail.com', 'Jombong RT. 02 RW. 01 Sudimoro Srumbung Magelang', 'Ahesudimoro', '$2y$10$Qjg5KSG0ReEewJB/NvaPcuH9IaR1iJOXhEot/n95BmbGEBRNDFkya', 'Profil-1766218612.jpeg', 'blue', 'Administrator', 'Ya', '2025-12-18 20:43:00');


